//
//  NSTextStorage+MCAdditions.h
//  MCApplication
//
//  Created by Ali Lalani on 10/4/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface NSTextStorage (MCAdditions)

// returns the text and attributes that would have been cut off. Removes those characters from this text storage
- (NSTextStorage *)residualTextStorageFromLayoutToSize:(NSSize)aSize;

- (NSSize)requiredSizeForDrawingInWidth:(float)aWidth;
- (void)drawInRect:(NSRect)rect view:(NSView *)aView truncate:(BOOL)flag; // truncate will use ellipsis at the end of the last line if necessary

- (BOOL)canDrawSequentialCharactersInSize:(NSSize)aSize;

- (void)setAttributedString: (NSAttributedString*)anAttributedString;

- (NSArray *)allAttachments;

@end
